;
; AED graphics jump table.
;

Get	equ	0x7900
Send	equ	Get+4
Dispa	equ	Get+8
Dchar	equ	Get+12
ChkKbd	equ	Get+16
Dcurs	equ	Get+20
Setup	equ	Get+24
Getb	equ	Get+28
Getw	equ	Get+32
Gcoor	equ	Get+36
Gdxdy	equ	Get+40
Sendb	equ	Get+44
Sendw	equ	Get+48
Scoor	equ	Get+52
Teki	equ	Get+56
Teka	equ	Get+60
Tekc	equ	Get+64
Alpha	equ	Get+68
Dfp	equ	Get+72

eeopt0	equ	0x400		; start of interpreter eeprom area.
;		+0(7)		destructive chars
;		+1(6)		local echo
;		+2(7)		tek priority
;		+3(7)		rubout
;		+4(6)		save serial input for vt100
;		  (7)		auto exit to vt100				

logomk	equ	0x500
logofn	equ	0x142e
;
; Graphics interpreter direct page.
;

	psect	1

;byte	equ 	1
;word 	equ 	2


;
;;;;;;;;;;;;;;;;; following is the block of data associated with ;;;;;;;;
;;;;;;;;;;;;;;;;; each window defined                            ;;;;;;;;
;

color	struct byte		; foreground color.
bcolor	struct byte		; background color
xpos	struct word		; x cap.
ypos	struct word		; y cap.
wmask	struct byte		; write mask.

wcapct	struct word		; image of Capctl, recorded at departure
				; from current window
wdaflg	struct word		; ditto for Daflag

;
; alpha mode
;
acolor	struct byte		; alpha cursor color.
acflag	struct byte		; bit 7 = alpha cursor drawn
				; bit 6 = alpha/gfx caps unlinked.
acx	struct word		; alpha cursor position.
acy	struct word

;
; margins - text
;
topmar	struct word		; text box boundaries.
botmar	struct word
lftmar	struct word
rgtmar	struct word

; note - don't mess with the placement of these variables
; (chrsiz .. fntbnk) without having a look at the
; sap and chr subroutines first !!
; 
chrsiz	struct byte	; bit 7 = double high, bit 6 = double wide.
cwidth	struct word	; char box width.
chight	struct word	; ditto height.
desc	struct word	; amt to drop cap before doing descender char.
csx	struct byte	; bits/row in char font.
csy	struct byte	; rows/char in char font.
fudge	struct word	; dist from y cap to top of char box.
fntptr	struct word	; long address (with next byte) 
fntbnk	struct byte	;   of the current char font.

chropt	struct byte	; bit 7 = erase bkgrnd before drawing char.

;
; graphics cursor
;
cutype	struct byte	; cursor shape.
curcol	struct byte	; cursor color.
cugrid	struct word	; scp
cuwmsk	struct byte	; scp

;
; window stuff
;
winox	struct word	; coords of lower left corner of window.
winoy	struct word
worgx	struct word	; window origin, relative to winox,winoy.
worgy	struct word
windx	struct word	; dimensions of current window.
windy	struct word

wblock	equ	windy-color+2	; window block size
;
;;;;;;;;;;; end of window data block ;;;;;;;;;;;;;;;
;


ledloc	equ	2		; local led mask.
ledcur	equ	32		; ditto cursor,
ledint	equ	4		; interpreter,
ledbsy	equ	8		; busy,


ocolor	struct byte		; overlay color.
rmask	struct byte		; read mask.
actime	struct word		; when to draw/erase cursor.
acbuf	struct word		; points to alpha cursor buffer.

;
; cdma
;
cdmflg	struct word		; set to poll cdma port.
cdmsw	struct word		; set to return hibyte of cdmbuf next.
cdmbuf	struct word		; last word from cdma port.

;
; aoi
;
aixorg	struct word		; aoi x origin.
aiyorg	struct word		; ditto y.
aimjsz	struct word		; aoi size in major direction.
aimnsz	struct word		; ditto minor direction.
aiflag	struct word		; Capctl image for aoi processing.
sucbyt	struct byte		; Capctl image for non-aoi commands
				; (suc,rrd,rhc,wrd,whc).

curdev	struct byte	; bit 7 = send tab coords on cursor update
			; if pen status has changed, unless ..
			; bit 6 = do the above only when status
			; is <> 0 (no data on pen up).
cudfmt	struct byte	; cursor device (0=joystick,'D' = GTCO decimal
			; format (xxxx,yyyy,f cdlf, '1' = bit pad one
			; low res packed binary.
curson	struct byte	; bit 7 = cursor enabled, 6 = cursor drawn.
			; bit 5 = cap is independent of cursor.
			; bit 4 = cursor device is not keyboard.
curbuf	struct word	; points to pixels saved by draw cursor routine.
curpat	struct word	; points to cursor pattern for user defined
			; 16x16 cursor.
cx	struct word	; cursor position.
cy	struct word

;
; cursor devices
;
tbstat	struct byte	; tablet status.
tbname	struct byte	; id char (etc etp rtp).
tbsizx	struct word	; actual tablet size in x.
tbsizy	struct word	; ditto y.
tbrawx	struct word	; umapped tablet coords.
tbrawy	struct word	; umapped tablet coords.
oldtab	struct byte	; previous tablet status.

dtmx	struct word	; tab coords of tab window origin (see dtm).
dtmy	struct word
dtmsx	struct word	; size in tab coords of tab window
dtmsy	struct word	; (default 2200x1700).

joyx	struct word	; joystick x position (0..2047)
joyy	struct word	; ditto y.
jdxdy	struct word	; amount to move joyx,joyy on arrow key.

;
; keyboard
;
resflg	struct	byte	; set if last key was setup.
rdykey	struct byte	; bit 7 = next key from keybuf,
			;     6 = next key from pfk sequence.
keybuf	struct byte	; 1 byte key buffer.
gldmod	struct byte	; set if last key was gold key.
locsw	struct byte	; bit 7 = local mode, 6 = local echo.
scrflg	struct byte	; bit 7 = noscroll key in effect.
arrkey	struct byte	; last arrow key code.
sksin	struct byte	; pointers into sks queue.
sksout	struct byte	
sksbuf	struct word	; points to queue of keys to send via sks.
pfkbuf	struct word	; points to list of pfks.
pfkptr	struct word	; points to currently executing pfk.

pfknam	equ	0
pfknxt	equ	2
pfksiz	equ	4
pfkidx	equ	6
pfkpop	equ	8
pfkdef	equ	10
;
; The pfks are stored in a linked list.
; Each list element looks like
; pfknam struct word	; the key code for the pfk (constant).
; pfknxt struct word	; points to next pfk in list (constant).
; pfksiz struct word	; # bytes in list element (constant).
; pfkidx struct word	; index (from pfknam) of next byte in sequence.
; pfkpop struct word	; points to 'parent' of this pfk.
; pfkdef struct word	; sequence of bytes for this pfk (pfksiz-10 bytes).
;

; The pfkpop field allows pfk definitions to be nested, i.e.
; dpk('A', "hello" goldkey "B!"), dpk('B', "world")
;  In this example, when 
; gold(A) is done, pfkptr is pointed to the list element for
; pfk(A).  Subsequent calls to chkkbd return h,e,l,l,o goldkey.
; When chkkbd encounters the B, it  saves pfkptr in the pfkpop field
; of the element for pfk(B) and makes pfk(B) the currently executing
; pfk.  Subsequent calls to chkkbd return w,o,r,l,d.  The next call
; to chkkbd finds that pfk(B) is exhausted, and so pfk(A) is resumed
; by restoring pfkptr from the pfkpop field in pfk(B).

;
; encoding schemes
;
sifval	struct byte	; how to send data to host (P,M,S,D).
otype	struct byte	; encoding scheme vars, see sen command.
rtype	struct byte
ctype	struct byte
ftype	struct byte
ptype	struct byte

;
; miscellaneous
;
wheap	struct word	; addr of an array of pointers for window data blocks
wname	struct byte	; id of window

stpnum	struct word	; current stipple pattern number.
stpbuf	struct word
lstyle	struct byte	; current line style.
bptype	struct byte

buffer	struct word	; points to heap acquired at powerup.
savptr	struct word	; points to buffer for save/restore font.
spfptr	struct word	; spf linked list header addr

autovt	struct byte	; bit 7 = call vt100 to handle serial input.
			; bit 6 = ignore serial input (this bit
			; ignored if bit 7 set).
rubopt	struct byte	; bit 7 = ignore rubout from host serial port.
			; this option should be handled by the asynch
			; interrupt routine, but for now Get does it.
;
; Tektronics stuff
;
hix	struct byte	; tek data byte storage
hiy	struct byte	
loy	struct byte
tekx	struct word	; decoded coords
teky	struct word
vflag	struct byte	; flag for tek modes
bflag	struct byte	; flag for data byte order
tekpri	struct byte	; bit 7 - set if Tek priority set in eeprom.
			; bit 6 - set if AED priority set by opt cmd.
			; bit 4 = opt(4).
			; bit 2 = opt(3),
			; bit 1 = opt(2),

;
; Next 14 bytes used as scratch
; by encoding/decoding io routines
; and dchar.
; 
edtemp	struct 4		; for decimal conversions.
iotemp	struct 6		; gcoor etc.
ctemp	struct 6		; for dchar and alpha cursor routines.
ctemp1	equ	ctemp+2
ctemp2	equ	ctemp+4

;
; Rest of the direct page is used for local 
; scratch by various (non I/O) subroutines.
; I/O routines are NOT allowed to use this space.
;
temp	struct	word
tmpblk	struct	256-temp
temp0	equ	temp
temp1	equ	tmpblk+2
temp2	equ	tmpblk+4
temp3	equ	tmpblk+6




	end


